function [A labels] = sequentialLayout(obj)
%SEQUENTIALLAYOUT Reorder rowLabels and columnLabels of AdjacencyMatrix
%object so as to find a sequential structure
%   [A labels] = sequentialLayout(obj) will return a square matrix A and labels
%   for rows and columns.  The ordering of rows and columns is determined
%   by an algorithms which attempts to determine a sequential structure.
%   This is outlined in:
%   Seung, HS.  Reading the Book of Memory: ..., Neuron Perspective 2009

[A labels] = getSquareMatrix(obj);
A = full(A);

% Form symmetrized graph Laplacian:
sym = A + A';
rowSums = diag(sum(sym));

L = rowSums - sym;

t = pinv(L) * (sum(A,1)' - sum(A,2));


[vals perm] = sort(t,'ascend');

A = A(perm,perm);
labels = labels(perm);




end

